/*
 * Created on 2015/09/04
 * Copyright (C) 2015 Koga Laboratory. All rights reserved.
 *
 */
package simulation;

import org.mklab.daej.ivps.IvpsBimdd;
import org.mklab.daej.ivps.IvpsDaejDifferentialAlgebraicEquation;
import org.mklab.daej.ivps.IvpsDaejDifferentialAlgebraicEquationSolver;

import problem.DoublePendulum;

public class DoublePendulumSimulation {

  public static void main(String[] args) {
    //　問題クラスを生成
    IvpsDaejDifferentialAlgebraicEquation problem = new DoublePendulum();

    //　解を求める時刻の設定
    final double[] t = {0.0, 30.0};

    //　ソルバーのドライバークラスを生成
    IvpsDaejDifferentialAlgebraicEquationSolver solver = new IvpsBimdd(problem);
    
    // シミュレーションパラメータの設定
    solver.setAbsoluteTolerance(1e-8);
    solver.setRelativeTolerance(1e-8);
    solver.setInitialStepSize(1e-8);
    // 問題を解く
    solver.solve(t);

    //　解を取得
    double[][] result = solver.getSolution();

    // 解を表示
    System.out.println("実行結果");
    for (int i = 0; i < result.length; i++) {
      for (int j = 0; j < result[0].length; j++) {
        Double ty = new Double(result[i][j]);
        String str = String.format("%15e ", ty);
        System.out.print(str);
      }
      System.out.println("");
    }
  }
}
